DROP PROCEDURE [hips].[HealthProviderOrganisationGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Philip Stalley-Gordon
-- Create date:   29/10/2013
-- Description:   Gets all records or a specific record from the HealthProviderOrganisation Table
-- =============================================
CREATE PROCEDURE [hips].[HealthProviderOrganisationGet] 
(
	@HealthProviderOrganisationId INT = NULL
)
AS
BEGIN
SELECT  hpo.HealthProviderOrganisationId,
		hpo.Name,
		hpo.HpiO,
		hpo.HiCertSerial,
		hpo.PcehrCertSerial,
		hpo.AuthorisedEmployeeName,
		hpo.AuthorisedEmployeeUserId,
		hpo.DateCreated,
		hpo.UserCreated,
		hpo.DateModified,
		hpo.UserModified
FROM  hips.HealthProviderOrganisation hpo
WHERE hpo.HealthProviderOrganisationId = @HealthProviderOrganisationId OR @HealthProviderOrganisationId IS NULL
END
GO

